﻿var questionLibrary = {
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        questionLibrary.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-questionTable").a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getAction("GetQuestions", "QuestionLibrary", "Library"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id" },
                //{ "Name": "TypeIcon", "Sortable": false, "Visible": true, "HideInSelector": true, "Title": "", "Width": "40px", "Data": function (row) { return  "<span class=\"" + "sprite-editor-icons img" + row['Type'] + "\"></span> " + "Name"; } },
                { "Name": "Name", "Title": resources.Name, "HideInSelector": true, "Class": "v-name", "Data": function (row) { return "<div style=\"float: left;\" class=\"sprite-editor-icons img" + row['Type'] + "\"></div> <div style=\"margin: 7px 0px 0px 10px;float: left;\">" + row['Name'] + "</div>"; } },
                { "Name": "Category", "Title": resources.Category, "Data": "Category" },
                { "Name": "TypeId", "Title": resources.Type, "Data": "TypeFormatted", "Type": "enum", "EnumType": "QuestionTypes" },
                { "Name": "Text", "Title": resources.Text, "Class": "v-text", "Width": "50%", "Data": function (row) {
                        var text = row['Text'];

                        if (text)
                            text = text.replace(/(<([^>]+)>)/ig, "");

                        return text;
                    }
                }
            ],
            localizableTexts: { "Search": resources.SearchQuestions },
            defaultSorting: { Column: "Id", Ascending: false },
            stateKey: "QuestionLibrary",
            toolBarItems: questionLibrary.getContextMenuItems(),
            contextMenuItems: questionLibrary.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "changeCategory":
                        questionLibrary.changeItemsCategory(ids);
                        break;
                    case "delete":
                        questionLibrary.deleteItems(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        questionLibrary.editItem(row);
                        break;
                    case "delete":
                        questionLibrary.deleteItems(row.Id);
                        break;
                }
            },
            rowBeforeCreated: function (event, data) {
                var row = data.row;
                var data = data.data;

                $(row).attr("data-id", data['Id']);
                $(row).attr("data-name", data['Name']);
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-manage-category", function () {
            modalDialog.showWindow(a4.getAction("CategoriesEditor", "QuestionLibrary", "Library"), 500, 950, { afterClose: function () { questionLibrary.datatable.a4datatable("refresh", true); } });
        });

        $(document).on("mouseenter", ".dataTable tbody tr", function () {
            var element = $(this);
            var id = element.attr("data-id");
            var preview = $("#previewQuestionContainer");

            // Don't show if currently displayed item
            if ((preview.is(":hidden") || preview.attr("data-id") != id)) {
                questionLibrary.previewTimer = setTimeout(function () { questionLibrary.showPreview(id, element); }, 900);
            }
        });

        $(document).on("mouseleave", ".dataTable tbody tr, #previewQuestionContainer", function (event) {
            var to = $(event.toElement);
            window.clearTimeout(questionLibrary.previewTimer);

            if (!to.hasClass("h-questionnaireItem") && to.closest(".h-popupMessage").length == 0) {
                $("#previewQuestionContainer").hide();
            }
        });
    },
    deleteItems: function (items) {

        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteQuestionResources, function () {
            a4.callServerMethod(a4.getAction("DeleteItems", "QuestionLibrary", "Library"), { itemIds: items },
                function (result) {
                    questionLibrary.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    changeItemsCategory: function (items) {
        questionLibrary.changeCategoryItems = items;
        modalDialog.showWindow(a4.getAction("ItemsCategoryEditor", "QuestionLibrary", "Library", { itemId: items[0] }), 250, 450, { afterClose: function () { questionLibrary.changeItemsCategoryOnClose(); } });
    },
    changeItemsCategoryOnSave: function (categoryId) {
        a4.callServerMethod(a4.getAction("UpdateItemsCategory", "QuestionLibrary", "Library"), { itemIds: questionLibrary.changeCategoryItems, categoryId: categoryId },
        function (result) {
            questionLibrary.changeCategoryItems = null;
            questionLibrary.refreshDataTable();
            modalDialog.close();
        },
        function (error) {
            questionLibrary.changeCategoryItems = null;
            modalDialog.close();
            var message = eval("(" + error.responseText + ")").Message;
            a4.showErrorMessage(message);
        });
    },
    changeItemsCategoryOnClose: function (categoryId) {
        questionLibrary.changeCategoryItems = null;
    },
    editItem: function (item) {
        modalDialog.showWindow(a4.getAction("ItemEditor", "MultimediaGallery", "Library", { fileId: item.Id }), 500, 950);
    },
    showPreview: function (id, element) {
        var preview = $("#previewQuestionContainer");

        if (preview.attr("data-id") == id) {
            preview.show();
        }

        else {
            a4.callServerMethod(a4.getAction("GetQuestionBrowserPreview", "QuestionLibrary", "Library"), { questionId: id },
            function (result) {
                preview.attr("data-id", id);

                $(".name", preview).text(element.attr("data-name"));
                $(".preview-container", preview).html(result);

                preview.show();
                preview.position({ my: "left top", at: "left bottom", of: element, collision: "flipfit" });
            });
        }
    },
    getContextMenuItems: function () {
        if (canModify) return [{ "Action": "delete", "Label": resources.Delete }];
        else return [];
    },
    getToolBarItems: function () {
        if (canModify) {
            return [{ "Action": "delete", "Label": resources.Delete },
                    { "Action": "changeCategory", "Label": resources.ChangeCategory }];
        }
        else return [];
    }
}

$(document).ready(function () {
    questionLibrary.initializeDataTable();
    questionLibrary.bindEvents();
});